#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

/*
typedef struct
{
  int width[8];
  int height[8];
  float cur_time;
  float total_time;
  float origROI[4];
  float resultROI[4];
}FilterParam;
*/
// auchor: RuanShengQiang 
//   data: 2017/6/28
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc);
}

vec4 Screen(vec4 base, vec4 blend)
{
    vec4 white = (vec4)(1.0f);
    vec4 result = white - ((white - blend) * (white - base));
    result.w = 1.0f;
    return result;
}

vec4 ColorDodge(vec4 base, vec4 blend)
{
    vec4 white = (vec4)(1.0f);
    vec4 result = base / (white - blend);
    return result;
}

__kernel  void MAIN(
	  __read_only image2d_t input1,
	  __read_only image2d_t input2,
      __write_only image2d_t dst,
      __global FilterParam* param,
	  int alpha
	  ) 
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	float2 resolution = (float2)(W,H);
	
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	
	float2 tc = (float2)(fragCoord.x, fragCoord.y)/resolution.xy;

	vec4 base = INPUTSRC(input1, param, tc);
	vec4 col = base; 
    base = ColorDodge(base, (vec4)((vec3)(0.2863f), 1.0f));
    
    vec4 blend = INPUT( input2, (vec2)(tc.x, 1.0 - tc.y) );
	
	vec4 outputCol = Screen(base, blend);
	write_imagef(dst, coordinate, col*(1.0f - alpha/100.0f) + (vec4)(outputCol.xyz, col.w)*alpha/100.0f);
}